/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.WLANExtInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetWLANExtInfo extends WLANSoapHelper<WLANExtInfo>
{
	/**
	 * Gets WLAN ExtInfo
	 * 
	 * @param soapCredentials
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 */
	public GetWLANExtInfo(ISoapCredentials soapCredentials, int interfaceIndex)
	{
		super(soapCredentials, interfaceIndex);
	}

	@Override
	public WLANExtInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		
		WLANExtInfo result = new WLANExtInfo();
		result.setAPEnabled(getValueByName("NewX_AVM-DE_APEnabled", input));
		result.setAPType(getValueByName("NewX_AVM-DE_APType", input));
		result.setTimeoutActive(getValueByName("NewX_AVM-DE_TimeoutActive", input));
		result.setTimeout(getValueByName("NewX_AVM-DE_Timeout", input));
		result.setTimeRemain(getValueByName("NewX_AVM-DE_TimeRemain", input));
		result.setNoForcedOff(getValueByName("NewX_AVM-DE_NoForcedOff", input));
		result.setUserIsolation(getValueByName("NewX_AVM-DE_UserIsolation", input));
		result.setEncryptionMode(getValueByName("NewX_AVM-DE_EncryptionMode", input));
		result.setLastChangedStamp(getValueByName("NewX_AVM-DE_LastChangedStamp", input));
		
		return result;
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_GetWLANExtInfo";
	}
}
