/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetSecurityKeys extends WLANSoapHelper<String>
{
	/**
	 * Gets the WLAN KeyPassphrase
	 * 
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 * @throws IllegalArgumentException
	 * 		illegal value of a member of mode
	 * @return KeyPassphrase of WPA/2.
	 * NewWEPKey0-3 and NewPreSharedKey are not interpreted/returned 
	 * 
	 */

	public GetSecurityKeys(ISoapCredentials soapCredentials, int interfaceIndex)
	{
		super(soapCredentials, interfaceIndex);
	}

	@Override
	public String getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		try
		{
			return getValueByName("NewKeyPassphrase", getSoapBody());
		}
		catch (DataMisformatException exp)
		{
			return null;
		}
	}

	@Override
	protected String filterSoapBeforeTrace(String body)
	{
        return replaceSecrets(body, new String[]
                {
                    "NewKeyPassphrase"
                    ,"NewPreSharedKey"
                    ,"NewWEPKey0"
                    ,"NewWEPKey1"
                    ,"NewWEPKey2"
                    ,"NewWEPKey3"
                });
	}

	@Override
	public String getSoapMethod()
	{
		return "GetSecurityKeys";
	}

}