/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wanipconnection;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.PortMapping;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class AddPortMapping extends WanIPConnectionSoapHelper<Boolean>
{
	private PortMapping mPortMapping;

	/**
	 * @throws IllegalArgumentException
	 * 		illegal value of a member of portMapping 
	 */
	public AddPortMapping(ISoapCredentials soapCredentials, PortMapping portMapping)
	{
		super(soapCredentials);
		
		UnsignedNumber.validateUi2(portMapping.getExternalPort(), "ExternalPort");
		UnsignedNumber.validateUi2(portMapping.getInternalPort(), "InternalPort");
		UnsignedNumber.validateUi4(portMapping.getLeaseDuration(), "LeaseDuration");
		
		mPortMapping = portMapping;
	}

    public PortMapping getPortMapping()
    {
        return mPortMapping;
    }

    /**
     * @throws IllegalArgumentException
     * 		illegal value of a member of portMapping
     */
    public AddPortMapping setPortMapping(PortMapping portMapping)
    {
        UnsignedNumber.validateUi2(portMapping.getExternalPort(), "ExternalPort");
        UnsignedNumber.validateUi2(portMapping.getInternalPort(), "InternalPort");
        UnsignedNumber.validateUi4(portMapping.getLeaseDuration(), "LeaseDuration");

        mPortMapping = portMapping;
        return this;
    }

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
		return Boolean.TRUE;
	}

    @Override
	public String getSoapMethodParameter()
	{
		return "<NewRemoteHost>" + mPortMapping.getRemoteHost() + "</NewRemoteHost>" +
				"<NewExternalPort>" + Integer.toString(mPortMapping.getExternalPort()) + "</NewExternalPort>" +
				"<NewProtocol>" + mPortMapping.getProtocol() + "</NewProtocol>" +
				"<NewInternalPort>" + Integer.toString(mPortMapping.getInternalPort()) + "</NewInternalPort>" +
				"<NewInternalClient>" + mPortMapping.getInternalClient() + "</NewInternalClient>" +
				"<NewEnabled>" + Integer.toString(mPortMapping.isEnabled() ? 1 : 0) + "</NewEnabled>" +
				"<NewPortMappingDescription>" + encodeEntities(mPortMapping.getPortMappingDescription()) + "</NewPortMappingDescription>" +
				"<NewLeaseDuration>" + Long.toString(mPortMapping.getLeaseDuration()) + "</NewLeaseDuration>";
	}

	@Override
	public String getSoapMethod()
	{
		return "AddPortMapping";
	}
}