/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.userinterface;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

import de.avm.android.tr064.soap.AbstractSoapHelper;
import de.avm.android.tr064.soap.ISoapCredentials;

public abstract class UserInterfaceSoapHelper<RESULT> extends AbstractSoapHelper<RESULT>
{
	/*
		Service Id  urn:UserInterface-com:serviceId:UserInterface1 
		Service Type  urn:dslforum-org:service:UserInterface:1 
		Control Url  /upnp/control/userif
		Scpd Url  /userifSCPD.xml
	*/
	
	public UserInterfaceSoapHelper(ISoapCredentials soapCredentials) 
	{
		super(soapCredentials);
	}

	public String getNamespace()
	{
		return "urn:dslforum-org:service:UserInterface:1";
	}

	public String getControlURL()
	{
		return "/upnp/control/userif";
	}

    protected long getDateTimeByName(String name, String input)
    {
        try
        {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.ZZZZZ",
                    Locale.US);
            return simpleDateFormat.parse(getValueByName(name, input)).getTime();
        }
        catch (ParseException ignored)
        {
            return 0; // default value or invalid string
        }
    }
}
