/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.userinterface;

import java.io.IOException;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.UpdateInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

/* Soap implementation for the UserInterface-Interface */
public class GetUpdateInfo extends UserInterfaceSoapHelper<UpdateInfo>
{
	public GetUpdateInfo(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public UpdateInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

        UpdateInfo updateInfo = new UpdateInfo();
		updateInfo.setAutoUpdateMode(getValueByName("NewX_AVM-DE_AutoUpdateMode", input));
		updateInfo.setUpdateTime(getDateTimeByName("NewX_AVM-DE_UpdateTime", input));
		updateInfo.setLastFwVersion(getValueByName("NewX_AVM-DE_LastFwVersion", input));
		updateInfo.setLastInfoURL(getValueByName("NewX_AVM-DE_LastInfoUrl", input));
		updateInfo.setCurrentFwVersion(getValueByName("NewX_AVM-DE_CurrentFwVersion", input));
		updateInfo.setUpdateSuccessful(getValueByName("NewX_AVM-DE_UpdateSuccessful", input));
		
		return updateInfo;
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_GetInfo";
	}
}