/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.appsetup;

import java.io.IOException;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.AppSetupInfo;
import de.avm.android.tr064.model.StringSpec;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetInfo extends AppSetupSoapHelper<AppSetupInfo>
{
    public GetInfo(ISoapCredentials soapCredentials)
    {
        super(soapCredentials);
    }

	@Override
	public AppSetupInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
        String input = getSoapBody();

        AppSetupInfo appSetupInfo = new AppSetupInfo();
		try
		{
            appSetupInfo.setAppIdSpec(new StringSpec(
                    getIntByName("NewMinCharsAppId", input),
                    getIntByName("NewMaxCharsAppId", input),
                    getValueByName("NewAllowedCharsAppId", input)));
            appSetupInfo.setAppDisplayNameSpec(new StringSpec(
                    getIntByName("NewMinCharsAppDisplayName", input),
                    getIntByName("NewMaxCharsAppDisplayName", input),
                    getValueByName("NewAllowedCharsAppDisplayName", input)));
            appSetupInfo.setAppUsernameSpec(new StringSpec(
                    getIntByName("NewMinCharsAppUsername", input),
                    getIntByName("NewMaxCharsAppUsername", input),
                    getValueByName("NewAllowedCharsAppUsername", input)));
            appSetupInfo.setAppPasswordSpec(new StringSpec(
                    getIntByName("NewMinCharsAppPassword", input),
                    getIntByName("NewMaxCharsAppPassword", input),
                    getValueByName("NewAllowedCharsAppPassword", input)));
            appSetupInfo.setIPSecIdentifierSpec(new StringSpec(
                    getIntByName("NewMinCharsIPSecIdentifier", input),
                    getIntByName("NewMaxCharsIPSecIdentifier", input),
                    getValueByName("NewAllowedCharsIPSecIdentifier", input)));
            appSetupInfo.setIPSecPreSharedKeySpec(new StringSpec(
                    getIntByName("NewMinCharsIPSecPreSharedKey", input),
                    getIntByName("NewMaxCharsIPSecPreSharedKey", input),
                    getValueByName("NewAllowedCharsIPSecPreSharedKey", input)));
            appSetupInfo.setIPSecXauthUsernameSpec(new StringSpec(
                    getIntByName("NewMinCharsIPSecXauthUsername", input),
                    getIntByName("NewMaxCharsIPSecXauthUsername", input),
                    getValueByName("NewAllowedCharsIPSecXauthUsername", input)));
            appSetupInfo.setIPSecXauthPasswordSpec(new StringSpec(
                    getIntByName("NewMinCharsIPSecXauthPassword", input),
                    getIntByName("NewMaxCharsIPSecXauthPassword", input),
                    getValueByName("NewAllowedCharsIPSecXauthPassword", input)));
		}
		catch (IllegalArgumentException exp)
		{
			throw new DataMisformatException(getInvalidResponseErrorMessage(), exp);
		}
        return appSetupInfo;
    }

	@Override
	public String getSoapMethod()
	{
		return "GetInfo";
	}
}