/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.sax;

import de.avm.android.tr064.Tr064Capabilities;

/*
 * SAX-Handler for FRITZ!Box Remote Access Config description
 */
public class SAXRemoteAccessScpdHandler extends SAXScpdHandler
{
	public boolean isCapabilitiyOfInterface(Tr064Capabilities cap)
	{
		return cap.has(Tr064Capabilities.Capability.REMOTEACCESS_INFO);
	}
	
	/**
	 * Instantiates a new sAX FRITZ!Box Remote Access Config description handler.
	 */
	public SAXRemoteAccessScpdHandler()
	{
		initActionsArray(new String[]
		{
			"GetInfo",
			"GetDDNSInfo",
		});
	}

	@Override
	public Tr064Capabilities getCapabilities()
	{
		if (mActions[0].mIsAvailable && mActions[1].mIsAvailable)
			return new Tr064Capabilities(
						Tr064Capabilities.Capability.REMOTEACCESS_INFO);
		return Tr064Capabilities.EMPTY;
	}
}
