/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents remote access information, as received from the Fritzbox 
 */
public class RemoteAccessInfo implements Parcelable
{
	/*
		NewEnabled  	out  Boolean
		NewPort         out  int
		NewUsername     out  String 
	*/
	
	private Boolean mEnabled = false;
	private int mPort = 0;
	private String mUsername = "";
	
	public boolean isEnabled()
	{
		return mEnabled;
	}
	
	public void setEnabled(boolean enabled)
	{
		mEnabled = enabled;
	}

	public int getPort()
	{
		return mPort;
	}

	public void setPort(int port)
	{
		mPort = port;
	}

	public String getUsername()
	{
		return mUsername;
	}

	public void setUsername(String username)
	{
		mUsername = username;
	}

	public RemoteAccessInfo(Parcel in)
	{
		mEnabled = in.readInt() != 0;
		mPort = in.readInt();
		mUsername = in.readString();
	}

	public RemoteAccessInfo()
	{
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<RemoteAccessInfo> CREATOR =
			new Parcelable.Creator<RemoteAccessInfo>()
	{
		public RemoteAccessInfo createFromParcel(Parcel in)
		{
			return new RemoteAccessInfo(in);
		}

		public RemoteAccessInfo[] newArray(int size)
		{
			return new RemoteAccessInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt((mEnabled) ? 1 : 0);
		out.writeInt(mPort);
		out.writeString(mUsername);
	}
}
