/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents online monitor information, as received from the Fritzbox 
 */
public class OnlineMonitorInfo implements Parcelable
{
	/*
		NewSyncGroupIndex         in   ui4    // Index beginnend mit 0 bis (TotalNumberSyncGroups-1)
		NewTotalNumberSyncGroups  out  ui4    // die Anzahl aktueller WAN-Verbindungen
		NewSyncGroupName          out  String // zB "sync_dsl"
		NewSyncGroupMode          out  String // zB "VDSL"
		Newmax_ds                 out  ui4    // maximale Bytes/Sekunde im Downstream
		Newmax_us                 out  ui4    // maximale Bytes/Sekunde im Upstream
		Newds_current_bps         out  String
		Newmc_current_bps         out  String
		Newus_current_bps         out  String
		Newprio_realtime_bps      out  String
		Newprio_high_bps          out  String
		Newprio_default_bps       out  String
		Newprio_low_bps           out  String 
	*/
	
	private long mSyncGroupIndex;
	private long mTotalNumberSyncGroups = 0;
	private String mSyncGroupName = "";
	private String mSyncGroupMode = "";
	private long mMaxDS = 0L;
	private long mMaxUS = 0L;
	private String mCurrentBpsDS = "";
	private String mCurrentBpsMC = "";
	private String mCurrentBpsUS = "";
	private String mPrioRealtimeBps = "";
	private String mPrioHighBps = "";
	private String mPrioDefaultBps = "";
	private String mPrioLowBps = "";
	
	public long getSyncGroupIndex()
	{
		return mSyncGroupIndex;
	}
	
	public long getTotalNumberSyncGroups()
	{
		return mTotalNumberSyncGroups;
	}

	public void setTotalNumberSyncGroups(long totalNumberSyncGroups)
	{
		mTotalNumberSyncGroups = totalNumberSyncGroups;
	}

	public String getSyncGroupName()
	{
		return mSyncGroupName;
	}

	public void setSyncGroupName(String syncGroupName)
	{
		mSyncGroupName = syncGroupName;
	}

	public String getSyncGroupMode()
	{
		return mSyncGroupMode;
	}

	public void setSyncGroupMode(String syncGroupMode)
	{
		mSyncGroupMode = syncGroupMode;
	}

	public long getMaxDS()
	{
		return mMaxDS;
	}

	public void setMaxDS(long maxDS)
	{
		mMaxDS = maxDS;
	}

	public long getMaxUS()
	{
		return mMaxUS;
	}

	public void setMaxUS(long maxUS)
	{
		mMaxUS = maxUS;
	}

	public OnlineMonitorInfo(long syncGroupIndex)
	{
		mSyncGroupIndex = syncGroupIndex;
	}
	
	public String getCurrentBpsDS()
	{
		return mCurrentBpsDS;
	}

	public void setCurrentBpsDS(String currentBpsDS)
	{
		mCurrentBpsDS = currentBpsDS;
	}

	public String getCurrentBpsMC()
	{
		return mCurrentBpsMC;
	}

	public void setCurrentBpsMC(String currentBpsMC)
	{
		mCurrentBpsMC = currentBpsMC;
	}

	public String getCurrentBpsUS()
	{
		return mCurrentBpsUS;
	}

	public void setCurrentBpsUS(String currentBpsUS)
	{
		mCurrentBpsUS = currentBpsUS;
	}

	public String getPrioRealtimeBps()
	{
		return mPrioRealtimeBps;
	}

	public void setPrioRealtimeBps(String prioRealtimeBps)
	{
		mPrioRealtimeBps = prioRealtimeBps;
	}

	public String getPrioHighBps()
	{
		return mPrioHighBps;
	}

	public void setPrioHighBps(String prioHighBps)
	{
		mPrioHighBps = prioHighBps;
	}

	public String getPrioDefaultBps()
	{
		return mPrioDefaultBps;
	}

	public void setPrioDefaultBps(String prioDefaultBps)
	{
		mPrioDefaultBps = prioDefaultBps;
	}

	public String getPrioLowBps()
	{
		return mPrioLowBps;
	}

	public void setPrioLowBps(String prioLowBps)
	{
		mPrioLowBps = prioLowBps;
	}

	public OnlineMonitorInfo(Parcel in)
	{
		mSyncGroupIndex = in.readLong();
		mTotalNumberSyncGroups = in.readLong();
		mSyncGroupName = in.readString();
		mSyncGroupMode = in.readString();
		mMaxDS = in.readLong();
		mMaxUS = in.readLong();
		mCurrentBpsDS = in.readString();
		mCurrentBpsMC = in.readString();
		mCurrentBpsUS = in.readString();
		mPrioRealtimeBps = in.readString();
		mPrioHighBps = in.readString();
		mPrioDefaultBps = in.readString();
		mPrioLowBps = in.readString();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<OnlineMonitorInfo> CREATOR =
			new Parcelable.Creator<OnlineMonitorInfo>()
	{
		public OnlineMonitorInfo createFromParcel(Parcel in)
		{
			return new OnlineMonitorInfo(in);
		}

		public OnlineMonitorInfo[] newArray(int size)
		{
			return new OnlineMonitorInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeLong(mSyncGroupIndex);
		out.writeLong(mTotalNumberSyncGroups);
		out.writeString(mSyncGroupName);
		out.writeString(mSyncGroupMode);
		out.writeLong(mMaxDS);
		out.writeLong(mMaxUS);
		out.writeString(mCurrentBpsDS);
		out.writeString(mCurrentBpsMC);
		out.writeString(mCurrentBpsUS);
		out.writeString(mPrioRealtimeBps);
		out.writeString(mPrioHighBps);
		out.writeString(mPrioDefaultBps);
		out.writeString(mPrioLowBps);
	}
}