/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on AppSetup info as received from the Fritzbox
 */
public class AppSetupInfo implements Parcelable
{
	/*
        NewMinCharsAppId out ui2
        NewMaxCharsAppId out ui2
        NewAllowedCharsAppId out string
        NewMinCharsAppDisplayName out ui2
        NewMaxCharsAppDisplayName out ui2
        NewAllowedCharsAppDisplayName out string
        NewMinCharsAppUsername out ui2
        NewMaxCharsAppUsername out ui2
        NewAllowedCharsAppUsername out string
        NewMinCharsAppPassword out ui2
        NewMaxCharsAppPassword out ui2
        NewAllowedCharsAppPassword out string
        NewMinCharsIPSecIdentifier out ui2
        NewMaxCharsIPSecIdentifier out ui2
        NewAllowedCharsIPSecIdentifier out string
        NewMinCharsIPSecPreSharedKey out ui2
        NewMaxCharsIPSecPreSharedKey out ui2
        NewAllowedCharsIPSecPreSharedKey out string
        NewMinCharsIPSecXauthUsername out ui2
        NewMaxCharsIPSecXauthUsername out ui2
        NewAllowedCharsIPSecXauthUsername out ui2
        NewMinCharsIPSecXauthPassword out ui2
        NewMaxCharsIPSecXauthPassword out ui2
        NewAllowedCharsIPSecXauthPassword out string
    */

    private StringSpec mAppIdSpec = null;
    private StringSpec mAppDisplayNameSpec = null;
    private StringSpec mAppUsernameSpec = null;
    private StringSpec mAppPasswordSpec = null;
    private StringSpec mIPSecIdentifierSpec = null;
    private StringSpec mIPSecPreSharedKeySpec = null;
    private StringSpec mIPSecXauthUsernameSpec = null;
    private StringSpec mIPSecXauthPasswordSpec = null;

    public StringSpec getAppIdSpec()
    {
        return mAppIdSpec;
    }

    public void setAppIdSpec(StringSpec spec)
    {
        mAppIdSpec = spec;
    }

    public StringSpec getAppDisplayNameSpec()
    {
        return mAppDisplayNameSpec;
    }

    public void setAppDisplayNameSpec(StringSpec spec)
    {
        mAppDisplayNameSpec = spec;
    }

    public StringSpec getAppUsernameSpec()
    {
        return mAppUsernameSpec;
    }

    public void setAppUsernameSpec(StringSpec spec)
    {
        mAppUsernameSpec = spec;
    }

    public StringSpec getAppPasswordSpec()
    {
        return mAppPasswordSpec;
    }

    public void setAppPasswordSpec(StringSpec spec)
    {
        mAppPasswordSpec = spec;
    }

    public StringSpec getIPSecIdentifierSpec()
    {
        return mIPSecIdentifierSpec;
    }

    public void setIPSecIdentifierSpec(StringSpec spec)
    {
        mIPSecIdentifierSpec = spec;
    }

    public StringSpec getIPSecPreSharedKeySpec()
    {
        return mIPSecPreSharedKeySpec;
    }

    public void setIPSecPreSharedKeySpec(StringSpec spec)
    {
        mIPSecPreSharedKeySpec = spec;
    }

    public StringSpec getIPSecXauthUsernameSpec()
    {
        return mIPSecXauthUsernameSpec;
    }

    public void setIPSecXauthUsernameSpec(StringSpec spec)
    {
        mIPSecXauthUsernameSpec = spec;
    }

    public StringSpec getIPSecXauthPasswordSpec()
    {
        return mIPSecXauthPasswordSpec;
    }

    public void setIPSecXauthPasswordSpec(StringSpec spec)
    {
        mIPSecXauthPasswordSpec = spec;
    }

    public AppSetupInfo()
    {
    }

    public int describeContents()
    {
        return 0;
    }

    public static final Parcelable.Creator<AppSetupInfo> CREATOR =
            new Parcelable.Creator<AppSetupInfo>()
            {
                public AppSetupInfo createFromParcel(Parcel in)
                {
                    return new AppSetupInfo(in);
                }

                public AppSetupInfo[] newArray(int size)
                {
                    return new AppSetupInfo[size];
                }
            };

    public AppSetupInfo(Parcel in)
    {
        mAppIdSpec = in.readParcelable (null);
        mAppDisplayNameSpec = in.readParcelable (null);
        mAppUsernameSpec = in.readParcelable (null);
        mAppPasswordSpec = in.readParcelable (null);
        mIPSecIdentifierSpec = in.readParcelable (null);
        mIPSecPreSharedKeySpec = in.readParcelable (null);
        mIPSecXauthUsernameSpec = in.readParcelable (null);
        mIPSecXauthPasswordSpec = in.readParcelable (null);
    }

    public void writeToParcel(Parcel out, int flags)
    {
        out.writeParcelable(mAppIdSpec, 0);
        out.writeParcelable(mAppDisplayNameSpec, 0);
        out.writeParcelable(mAppUsernameSpec, 0);
        out.writeParcelable(mAppPasswordSpec, 0);
        out.writeParcelable(mIPSecIdentifierSpec, 0);
        out.writeParcelable(mIPSecPreSharedKeySpec, 0);
        out.writeParcelable(mIPSecXauthUsernameSpec, 0);
        out.writeParcelable(mIPSecXauthPasswordSpec, 0);
    }
}