/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

/*
 *  Represents information on AppSetup config as received from the Fritzbox
 */
public class AppSetupConfig
{
	/*
        NewConfigRight out RightEnum
        NewAppRight out RightEnum
        NewNasRight out RightEnum
        NewPhoneRight out RightEnum
        NewDialRight out RightEnum
        NewHomeautoRight out RightEnum
        NewInternetRights out boolean
        NewAccessFromInternet out boolean
    */

    private RightEnum mConfigRight;
    private RightEnum mAppRight;
    private RightEnum mNasRight;
    private RightEnum mPhoneRight;
    private RightEnum mDialRight;
    private RightEnum mHomeautoRight;
    private boolean mInternetRights;
    private boolean mAccessFromInternet;

    public RightEnum getConfigRight()
    {
        return mConfigRight;
    }

    public void setConfigRight(RightEnum right)
    {
        mConfigRight = right;
    }

    public RightEnum getAppRight()
    {
        return mAppRight;
    }

    public void setAppRight(RightEnum right)
    {
        mAppRight = right;
    }

    public RightEnum getNasRight()
    {
        return mNasRight;
    }

    public void setNasRight(RightEnum right)
    {
        mNasRight = right;
    }

    public RightEnum getPhoneRight()
    {
        return mPhoneRight;
    }

    public void setPhoneRight(RightEnum right)
    {
        mPhoneRight = right;
    }

    public RightEnum getDialRight()
    {
        return mDialRight;
    }

    public void setDialRight(RightEnum right)
    {
        mDialRight = right;
    }

    public RightEnum getHomeautoRight()
    {
        return mHomeautoRight;
    }

    public void setHomeautoRight(RightEnum right)
    {
        mHomeautoRight = right;
    }

    public boolean isInternetRights()
    {
        return mInternetRights;
    }

    public void setInternetRights(boolean internetRights)
    {
        mInternetRights = internetRights;
    }

    public boolean isAccessFromInternet()
    {
        return mAccessFromInternet;
    }

    public void setAccessFromInternet(boolean accessFromInternet)
    {
        mAccessFromInternet = accessFromInternet;
    }
}