/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.views;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.preference.Preference;
import android.util.AttributeSet;
import de.avm.fundamentals.R;

public class VersionPreference extends Preference {

    private PackageInfo mPackageInfo;

    public VersionPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        initPreference(context, attrs);
    }

    public VersionPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPreference(context, attrs);
    }

    private void initPreference(Context context, AttributeSet attrs) {
        try {
            mPackageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        StringBuilder versionText = new StringBuilder();
        versionText.append(getContext().getString(R.string.version_label, mPackageInfo.versionName)).append("\n");
        versionText.append(getContext().getString(R.string.avm_copyright)).append("\n");
        versionText.append(getContext().getString(R.string.avm_link));
        setSummary(versionText.toString());
    }
}
