/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.activities;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import de.avm.fundamentals.R;
import de.avm.fundamentals.logger.FileLog;

public class LogActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.log_activity);

//        initLogWebView();
        initLogList();

        initActionBar();
    }

//    private void initLogWebView() {
//        WebView webView = (WebView) findViewById(R.id.log_web_view);
//        StringBuilder logFileContent = new StringBuilder();
//        ArrayList<String> logAsList = FileLog.getLogAsList();
//        for(String line : logAsList){
//            logFileContent.append(line);
//        }
//
//
//        /**
//         * log {
//         white-space: pre;
//         font: 11px TrebuchetMS;
//         padding: 5px;
//         }
//         */
//        String css = "style=\"white-space: pre; font: 11px; padding: 5px;\"";
//        String xmlLogFormat = "<html><style type=\"text/css\">body { font: 8px; padding: 5px; }</style><body>%s</body></html>";
//        webView.loadData(String.format(xmlLogFormat, logFileContent.toString()), "text/html", "utf-8");
//
//    }

    private void initLogList() {
        ListView list = (ListView) findViewById(R.id.log_list);
        final ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(this, R.layout.log_list_entry);
        arrayAdapter.addAll(FileLog.getLogAsList());
        list.setAdapter(arrayAdapter);
        list.setSelection(arrayAdapter.getCount() - 1);
    }

    private void initActionBar() {
        ActionBar actionBar = getActionBar();
        if(actionBar != null){
            actionBar.setTitle(R.string.actionbar_title_feedback);
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if(item.getItemId() == android.R.id.home){
            finish();
        }
        return super.onOptionsItemSelected(item);
    }
}
