/* 
 * Copyright 2010 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package org.sipdroid.media;

public class AudioFilterDecimation extends AudioFilter  
{
	public AudioFilterDecimation()
	{
		Init();
	}

	public void Init()
	{
		for(int i = 0; i < m_buf.length; ++i)
			m_buf[i]=0;
		m_count = 0;
	}

	// Konvertiert nSamples Samples im Format 16kHz-Mono-WAV aus *pData nach 8kHz-Mono-WAV und
	// legt diese in *pData ab. Es wird die Anzahl der abgelegten Samples zurückgegeben.
	// PRE: nSamples % 2 == 0
	public int Convert(short [] pData, int nSamples, int offset, short[] out)
	{
		/*---------------------------------------------------------------------------*\
		FIR-Filter mit 64 float-Koeffizienten
		input:	inputlen	Audiosamples			(16 kHz)
		output:	inputlen/2	gefilterte Audiosamples	( 8 kHz)
		\*---------------------------------------------------------------------------*/

		assert(nSamples % 2 == 0);

		int nOut = 0;
		for(int i = offset; i < nSamples+offset; i += 2) {
			/*-------------------- 2 Samples rein ----*/
		    if(m_count >= DEZIMATION_FILTER_LEN)
			   m_count = 0;
	        m_buf[m_count] = m_buf[m_count + AudioFilter.DEZIMATION_FILTER_LEN] = pData[i];
			if(++m_count >= DEZIMATION_FILTER_LEN)
				m_count = 0;
			m_buf[m_count] = m_buf[m_count + AudioFilter.DEZIMATION_FILTER_LEN] = pData[i + 1];
			if(++m_count >= DEZIMATION_FILTER_LEN)
				m_count = 0;
			/*-------------------- FIR-Filter --------*/
			float res = 0.0f;
			for(int k = 0; k < DEZIMATION_FILTER_LEN; ++k)
				res += c_koeffizienten[k] * m_buf[m_count+k];
			res /= 2.0f;

			//pData[i>>1] = AudioFilter.float2short(res);
			out[nOut] = AudioFilter.float2short(res);
			++nOut;
		}

		return nOut;
	}

	/*
	public int Convert(short [] pData, int nSamples, int offset)
	{
		//---------------------------------------------------------------------------
		// FIR-Filter mit 64 float-Koeffizienten
		// input:	inputlen	Audiosamples			(16 kHz)
		// output:	inputlen/2	gefilterte Audiosamples	( 8 kHz)
		//---------------------------------------------------------------------------

		assert(nSamples % 2 == 0);

		int nOut = 0;
		for(int i = offset; i < nSamples+offset; i += 2) {
			//-------------------- 2 Samples rein ----
		    if(m_count >= DEZIMATION_FILTER_LEN)
			   m_count = 0;
	        m_buf[m_count] = m_buf[m_count + AudioFilter.DEZIMATION_FILTER_LEN] = pData[i];
			if(++m_count >= DEZIMATION_FILTER_LEN)
				m_count = 0;
			m_buf[m_count] = m_buf[m_count + AudioFilter.DEZIMATION_FILTER_LEN] = pData[i + 1];
			if(++m_count >= DEZIMATION_FILTER_LEN)
				m_count = 0;
			//-------------------- FIR-Filter --------
			float res = 0.0f;
			for(int k = 0; k < DEZIMATION_FILTER_LEN; ++k)
				res += c_koeffizienten[k] * m_buf[m_count+k];
			res /= 2.0f;

			pData[i>>1] = AudioFilter.float2short(res);
			++nOut;
		}

		return nOut;
	}
	*/
	
	protected short [] m_buf = new short[2 * AudioFilter.DEZIMATION_FILTER_LEN];
	protected int m_count;
};
