/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

public abstract class DeviceConfigSoapHelper<RESULT> extends AbstractSoapHelper<RESULT>
{
	/*
	Service Id  urn:DeviceInfo-com:serviceId:DeviceConfig1 
	Service Type  urn:dslforum-org:service:DeviceConfig:1 
	Control Url  /upnp/control/deviceconfig
	Scpd Url  /deviceconfigSCPD.xml
	*/
	
	public DeviceConfigSoapHelper(ISoapCredentials soapCredentials) 
	{
		super(soapCredentials);
	}

	public String getNamespace()
	{
		return "urn:dslforum-org:service:DeviceConfig:1";
	}

	public String getControlURL()
	{
		return "/upnp/control/deviceconfig";
	}
}