/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.net;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

/**
 *	HttpRequestInterceptor which adds gzip header
 */
public class GzipHttpRequestInterceptor implements HttpRequestInterceptor
{
	public void process(HttpRequest request, HttpContext context)
			throws HttpException, IOException
	{
        if (!request.containsHeader("Accept-Encoding"))
		    request.addHeader("Accept-Encoding", "gzip");
	}
}
