/*
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

/*
 *  Represents information about a port mapping. As received from the FritzBox.
 */
public class MyFritzService {
	private int mIndex = -1;
	private String mDynDnsLabel = "";
	private boolean mEnabled = false;
	private String mHostName = "";
	private String mIPv4Addresses = "";
	public enum IPv4ForwardingWarning {
		UNKNOWN(0), NOT_NECESSARY_OR_SUCCEEDED(1), FAILED(2);
		private final int codeIPv4ForwardingWarning;

		IPv4ForwardingWarning(int warning) {
			this.codeIPv4ForwardingWarning = warning;
		}

		public int getCodeIPv4ForwardingWarning() {
			return this.codeIPv4ForwardingWarning;
		}
	};
	private IPv4ForwardingWarning mIPv4ForwardingWarning = IPv4ForwardingWarning.UNKNOWN;
	private String mIPv6Addresses = "";
	private String mIPv6InterfaceIDs = "";
	private String mMACAddress = "";
	private String mName = "";
	private int mPort = 0;
	private String mScheme = "";
	private int mStatus = 0;
	private String mURLPath = "";

	public int getIndex() {
		return mIndex;
	}

	public void setIndex(int index) {
		mIndex = index;
	}

	public String getDynDnsLabel() {
		return mDynDnsLabel;
	}

	public void setDynDnsLabel(String dynDnsLabel) {
		mDynDnsLabel = dynDnsLabel;
	}

	public boolean isEnabled() {
		return mEnabled;
	}

	public void setEnabled(boolean enabled) {
		mEnabled = enabled;
	}

	public String getHostName() {
		return mHostName;
	}

	public void setHostName(String hostName) {
		mHostName = hostName;
	}

	public String getIPv4Addresses() {
		return mIPv4Addresses;
	}

	public void setIPv4Addresses(String ipv4Addresses) {
		mIPv4Addresses = ipv4Addresses;
	}

	public IPv4ForwardingWarning getIPv4ForwardingWarning() {
		return mIPv4ForwardingWarning;
	}

	public void setIPv4ForwardingWarning(IPv4ForwardingWarning ipv4ForwardingWarning) {
		mIPv4ForwardingWarning = ipv4ForwardingWarning;
	}

	public String getIPv6Addresses() {
		return mIPv6Addresses;
	}

	public void setIPv6Addresses(String ipv6Addresses) {
		mIPv6Addresses = ipv6Addresses;
	}

	public String getIPv6InterfaceIDs() {
		return mIPv6InterfaceIDs;
	}

	public void setIPv6InterfaceIDs(String ipv6InterfaceIDs) {
		mIPv6InterfaceIDs = ipv6InterfaceIDs;
	}

	public String getMACAddress() {
		return mMACAddress;
	}

	public void setMACAddress(String macAddress) {
		mMACAddress = macAddress;
	}

	public String getName() {
		return mName;
	}

	public void setName(String name) {
		mName = name;
	}

	public int getPort() {
		return mPort;
	}

	public void setPort(int port) {
		mPort = port;
	}

	public String getScheme() {
		return mScheme;
	}

	public void setScheme(String scheme) {
		mScheme = scheme;
	}

	public int getStatus() {
		return mStatus;
	}

	public void setStatus(int status) {
		mStatus = status;
	}

	public String getURLPath() {
		return mURLPath;
	}

	public void setURLPath(String urlPath) {
		mURLPath = urlPath;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");

		result.append(this.getClass().getName() + "Object {" + NEW_LINE);
		result.append(" Index: " + mIndex + NEW_LINE);
		result.append(" DynDNSLabel: " + mDynDnsLabel + NEW_LINE);
		result.append(" Enabled: " + mEnabled + NEW_LINE);
		result.append(" HostName: " + mHostName + NEW_LINE);
		result.append(" IPv4Addresses: " + mIPv4Addresses + NEW_LINE);
		result.append(" IPv4ForwardingWarning: " + mIPv4ForwardingWarning + NEW_LINE);
		result.append(" IPv6Addresses: " + mIPv6Addresses + NEW_LINE);
		result.append(" IPv6InterfaceIDs: " + mIPv6InterfaceIDs + NEW_LINE);
		result.append(" MACAddress: " + mMACAddress + NEW_LINE);
		result.append(" Name: " + mName + NEW_LINE);
		result.append(" Port: " + mPort + NEW_LINE);
		result.append(" Scheme: " + mScheme + NEW_LINE);
		result.append(" Status: " + mStatus + NEW_LINE);
		result.append(" URL Path: " + mURLPath + NEW_LINE);
		result.append("}");

		return result.toString();
	}
}
