/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.PortMapping;

public class GetSpecificPortMappingEntry extends
		WANPPPConnectionSoapHelper<PortMapping> {
	private String mRemoteHost = "";
	private int mExternalPort = 0;
	private String mProtocol = "";

	public GetSpecificPortMappingEntry(ISoapCredentials soapCredentials,
			String remoteHost, int externalPort, String protocol) {
		super(soapCredentials);

		mRemoteHost = remoteHost;
		mExternalPort = externalPort;
		mProtocol = protocol;
	}

	@Override
	public PortMapping getQualifiedResult() throws DataMisformatException,
			BaseException, IOException {
		PortMapping portMapping = new PortMapping();
		portMapping.setRemoteHost(mRemoteHost);
		portMapping.setExternalPort(mExternalPort);
		portMapping.setProtocol(mProtocol);

		String input = getSoapBody();
		Matcher m = Pattern.compile(
				"<NewInternalPort>(.*?)<\\/NewInternalPort>").matcher(input);
		if (m.find()) {
			try {
				portMapping.setInternalPort(Integer.parseInt(decodeEntities(m
						.group(1))));
			} catch (NumberFormatException exp) {
				throw new DataMisformatException(
						MISFORMATEXCEPTIONDESCRIPTION, exp);
			}
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewInternalClient>(.*?)<\\/NewInternalClient>")
				.matcher(input);
		if (m.find()) {
			portMapping.setInternalClient(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewEnabled>(.*?)<\\/NewEnabled>").matcher(input);
		try {
			int enable = (m.find()) ? Integer.parseInt(m.group(1)) : -1;
			if (enable == 0)
				portMapping.setEnabled(false);
			else if (enable == 1)
				portMapping.setEnabled(true);
			else
				throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);
		} catch (NumberFormatException exp) {
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION,
					exp);
		}

		m = Pattern
				.compile(
						"<NewPortMappingDescription>(.*?)<\\/NewPortMappingDescription>")
				.matcher(input);
		if (m.find()) {
			portMapping.setPortMappingDescription(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewLeaseDuration>(.*?)<\\/NewLeaseDuration>")
				.matcher(input);
		if (m.find()) {
			try {
				portMapping.setLeaseDuration(Integer.parseInt(decodeEntities(m
						.group(1))));
			} catch (NumberFormatException exp) {
				throw new DataMisformatException(
						MISFORMATEXCEPTIONDESCRIPTION, exp);
			}
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		return portMapping;
	}

	@Override
	public String getSoapMethodParameter() {
		String params = "<NewRemoteHost>" + mRemoteHost + "</NewRemoteHost>" +
				"<NewExternalPort>" + mExternalPort + "</NewExternalPort>" +
				"<NewProtocol>" + mProtocol + "</NewProtocol>";
		return params;
	}

	@Override
	public String getSoapMethod() {
		return "GetSpecificPortMappingEntry";
	}
}