/* 
 * Copyright 2011 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.util;

import java.util.Random;

public class PasswordBuilder
{
	private CharSequence mValidChars = "";
	private int mLength = 8;
	private Random mRandom = new Random();
	
	public PasswordBuilder()
	{
	}
	
	public PasswordBuilder setValidChars(CharSequence chars)
	{
		mValidChars = chars;
		return this;
	}
	
	public PasswordBuilder setLength(int length)
	{
		mLength = length;
		return this;
	}
	
	public String create()
	{
		StringBuilder password = new StringBuilder(mLength);
		if (mValidChars.length() > 0)
			for (int ii = 0; ii < mLength; ii++)
				password.append(mValidChars.charAt(
						mRandom.nextInt(mValidChars.length())));
		
		return password.toString();
	}
}
