/*---------------------------------------------------------------------------*\

    CLINUX.C    Version 1.0                                         1997 AVM

    This file contains the source of the operating system specific
    CAPI functions, here for LINUX user-mode applications. See CAPI 2.0 spec.

\*---------------------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <linux/capi.h>
#include "./capi20.h"
#define __NO_CAPIUTILS__
#include "/usr/include/capi20.h"

unsigned CAPI20_ISINSTALLED (void)
{
    return capi20_isinstalled() == CapiNoError;
}

_cword CAPI20_REGISTER (unsigned MaxB3Connection,
                        unsigned MaxB3Blks,
                        unsigned MaxSizeB3,
                        CAPI_REGISTER_ERROR *ErrorCode)
{
    unsigned applid;
    CAPI_REGISTER_ERROR err;

    err = capi20_register (MaxB3Connection, MaxB3Blks, MaxSizeB3, &applid);

    *ErrorCode = err;
    if (err != CapiNoError)
       return 0;
    return (_cword)applid;
}

MESSAGE_EXCHANGE_ERROR CAPI20_RELEASE (unsigned Appl_Id)
{
    return (MESSAGE_EXCHANGE_ERROR)capi20_release (Appl_Id);
}

MESSAGE_EXCHANGE_ERROR CAPI20_PUT_MESSAGE (CAPI_MESSAGE Msg, unsigned Appl_Id)
{
    MESSAGE_EXCHANGE_ERROR ret;
    ret = capi20_put_message(Appl_Id, Msg);
#if defined (CPROT_LINUX)
    if (ret == CapiNoError)
        CAPI_PROTOCOL_MESSAGE (Msg);
    else
        CAPI_PROTOCOL_TEXT ("CAPI_PUT_MESSAGE error 0x%04x\n", ret);
#endif
    return ret;
}

MESSAGE_EXCHANGE_ERROR CAPI20_GET_MESSAGE (unsigned Appl_Id, CAPI_MESSAGE  *ReturnMessage)
{
    MESSAGE_EXCHANGE_ERROR ret;
    ret = capi20_get_message(Appl_Id, (unsigned char **)ReturnMessage);
#if defined (CPROT_LINUX)
    if (ret == CapiNoError)
        CAPI_PROTOCOL_MESSAGE (*ReturnMessage);
    else if (ret != CapiReceiveQueueEmpty)
        CAPI_PROTOCOL_TEXT ("CAPI_GET_MESSAGE error 0x%04x\n", ret);
#endif
    return ret;
}

CAPI_MESSAGE CAPI20_GET_MANUFACTURER (CAPI_MESSAGE LpBuffer)
{
    return (CAPI_MESSAGE)capi20_get_manufacturer(0, (unsigned char *)LpBuffer);
}

CAPI_MESSAGE CAPI20_GET_VERSION (CAPI_MESSAGE version)
{
    return (CAPI_MESSAGE)capi20_get_version(0, (unsigned char *)version);
}

CAPI_MESSAGE  CAPI20_GET_SERIAL_NUMBER (CAPI_MESSAGE LpBuffer)
{
    return (CAPI_MESSAGE)capi20_get_serial_number(0, (unsigned char *)LpBuffer);
}

MESSAGE_EXCHANGE_ERROR CAPI20_GET_PROFILE (unsigned Controller, CAPI_MESSAGE LpBuffer)
{
    return (MESSAGE_EXCHANGE_ERROR)
		capi20_get_profile(Controller, (unsigned char *)LpBuffer);
}
