/*--------------------------------------------------------------------------*\

    CERR2STR.C      Version 1.0                                     2000 AVM

    This file contains the source for translating functions for
    CAPI-errors to strings.

\*--------------------------------------------------------------------------*/
#include "cerr2str.h"


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static char csRtn[128];


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
const char * CapiExErrorToString(MESSAGE_EXCHANGE_ERROR error) {

    switch(error) {
    case CapiNoError:                      strcpy (csRtn, "CapiNoError"                     ); break;
    case CapiIllAppNr:                     strcpy (csRtn, "CapiIllAppNr"                    ); break;
    case CapiIllCmdOrSubcmdOrMsgToSmall:   strcpy (csRtn, "CapiIllCmdOrSubcmdOrMsgToSmall"  ); break;
    case CapiSendQueueFull:                strcpy (csRtn, "CapiSendQueueFull"               ); break;
    case CapiReceiveOverflow:              strcpy (csRtn, "CapiReceiveOverflow"             ); break;
    case CapiUnknownNotPar:                strcpy (csRtn, "CapiUnknownNotPar"               ); break;
    case CapiMsgBusy:                      strcpy (csRtn, "CapiMsgBusy"                     ); break;
    case CapiMsgOSResourceErr:             strcpy (csRtn, "CapiMsgOSResourceErr"            ); break;
    case CapiMsgCtrlerNotSupportExtEquip:  strcpy (csRtn, "CapiMsgCtrlerNotSupportExtEquip" ); break;
    case CapiMsgCtrlerOnlySupportExtEquip: strcpy (csRtn, "CapiMsgCtrlerOnlySupportExtEquip"); break;
    case CapiMsgNotInstalled:              strcpy (csRtn, "ECapiMsgNotInstalled"            ); break;
    default:                               strcpy (csRtn, "ERROR not defined!"); break;
    }

    return csRtn;
}


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
const char * CapiReErrorToString(CAPI_REGISTER_ERROR error) {

    switch(error) {
    case CapiRegNoError:                   strcpy (csRtn, "CapiRegNoError"                  ); break;
    case CapiToManyAppls:                  strcpy (csRtn, "CapiToManyAppls"                 ); break;
    case CapiLogBlkSizeToSmall:            strcpy (csRtn, "CapiLogBlkSizeToSmall"           ); break;
    case CapiMsgBufSizeToSmall:            strcpy (csRtn, "CapiMsgBufSizeToSmall"           ); break;
    case CapiAnzLogConnNotSupported:       strcpy (csRtn, "CapiAnzLogConnNotSupported"      ); break;
    case CapiRegBusy:                      strcpy (csRtn, "CapiRegBusy"                     ); break;
    case CapiRegOSResourceErr:             strcpy (csRtn, "CapiRegOSResourceErr"            ); break;
    case CapiRegCtrlerNotSupportExtEquip:  strcpy (csRtn, "CapiRegCtrlerNotSupportExtEquip" ); break;
    case CapiRegCtrlerOnlySupportExtEquip: strcpy (csRtn, "CapiRegCtrlerOnlySupportExtEquip"); break;
    case CapiRegNotInstalled:              strcpy (csRtn, "CapiRegNotInstalled"             ); break;
    default:                               strcpy (csRtn, "ERROR not defined!"); break;
    }

    return csRtn;
}


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
